function x_v = read_cplexsol(solfile)
% READ_CPLEXSOL
%
%   x = cplexsol2mat(solfile)
%
%   Reads a CPLEX .sol xml file and extracts the solution. Returned is
%   the solution in form of a column vector x. The cplex solution file can
%   be created with the WRITE command in cplex.
%
%
%   Thomas Trtscher
%

xDoc = xmlread(solfile);
allVariables = xDoc.getElementsByTagName('variable');
x_v=zeros(allVariables.getLength,1);
% Note that the variable list index is zero-based.
for k = 0:allVariables.getLength-1
    thisVariable = allVariables.item(k);
    x_v(k+1) = str2double(thisVariable.getAttribute('value'));
end  % End FOR

load('maticaCplex.txt');

pocetCiest = maticaCplex(1,1);
pocetVybratychHran = maticaCplex(2,1);
pocetHran = maticaCplex(3,1);
pocetVrcholov = maticaCplex(4,1);

X_R = load('maticaCplexX.txt');
Y_R = load('maticaCplexY.txt');

dlmwrite('CestyCplex.txt', pocetCiest, 'newline', 'pc', 'delimiter','\t');

for i=1:pocetCiest
    X = zeros(pocetVrcholov, pocetVrcholov);
    for e=1:pocetVybratychHran
       blok = (pocetVybratychHran + pocetHran + pocetVrcholov) * (i-1);
       hr = blok + e;
       if (x_v(hr,1) == 1)
           x_hr = X_R(1,e);
           Y_hr = Y_R(1,e);
           X(x_hr, Y_hr) = 1;
       end
    end
    dlmwrite('CestyCplex.txt', X, '-append', 'newline', 'pc', 'delimiter','\t');
end